<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectContractor extends Model 
{

    protected $table = 'project_contractor';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'contractor_id');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function contractor()
    {
        return $this->belongsTo('Contractor', 'contractor_id');
    }

}