<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 50);
			$table->enum('type', array('amount', 'percentage'))->nullable();
			$table->double('value')->nullable();
			$table->date('from_date')->nullable();
			$table->date('to_date')->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
			$table->integer('use_count')->nullable();
			$table->integer('zone_id')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}