<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('education', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hashtag', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('network', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('network', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_user_id_foreign');
		});
		Schema::table('education', function(Blueprint $table) {
			$table->dropForeign('education_user_id_foreign');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_user_id_foreign');
		});
		Schema::table('hashtag', function(Blueprint $table) {
			$table->dropForeign('hashtag_post_id_foreign');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->dropForeign('post_like_user_id_foreign');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->dropForeign('post_like_post_id_foreign');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->dropForeign('post_comments_user_id_foreign');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->dropForeign('post_comments_post_id_foreign');
		});
		Schema::table('network', function(Blueprint $table) {
			$table->dropForeign('network_sender_id_foreign');
		});
		Schema::table('network', function(Blueprint $table) {
			$table->dropForeign('network_receiver_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_user_id_foreign');
		});
	}
}