<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('invitations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_id')->index();
			$table->integer('user_id')->index();
			$table->string('email');
			$table->string('token', 40)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invitations');
	}
}