<?php

namespace App/Models/backend/BookCopy;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BookCopy extends Model 
{

    protected $table = 'book_copies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function book()
    {
        return $this->belongsTo('App/Models/backend/Book\Book', 'book_id');
    }

    public function publicationHose()
    {
        return $this->belongsTo('PublishingHouse');
    }

    public function author()
    {
        return $this->belongsTo('Author');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

}