<?php

namespace App/Models/backend/Book;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Book extends Model 
{

    protected $table = 'books';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function publicationHose()
    {
        return $this->belongsTo('PublishingHouse');
    }

    public function author()
    {
        return $this->belongsTo('Author');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

}