<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tbl_user', function(Blueprint $table) {
			$table->foreign('company_id')->references('company_id')->on('tbl_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_equipment_type', function(Blueprint $table) {
			$table->foreign('equipment_category_id')->references('equipment_category_id')->on('tbl_setting_equipment_category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tbl_setting_particular', function(Blueprint $table) {
			$table->foreign('particular_category_id')->references('particular_category_id')->on('tbl_setting_particular_category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tbl_fleet', function(Blueprint $table) {
			$table->foreign('owner_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('tbl_user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tbl_vessel', function(Blueprint $table) {
			$table->foreign('fleet_id')->references('fleet_id')->on('tbl_fleet')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tbl_vessel', function(Blueprint $table) {
			$table->foreign('vessel_type_id')->references('vessel_type_id')->on('tbl_setting_vessel_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_particular', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('vessel_id')->on('tbl_vessel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_particular', function(Blueprint $table) {
			$table->foreign('particular_id')->references('particular_id')->on('tbl_setting_particular')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tbl_vessel_equipment', function(Blueprint $table) {
			$table->foreign('vessel_equipment_type_id')->references('vessel_equipment_type_id')->on('tbl_vessel_equipment_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_equipment', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('equipment_id')->on('tbl_setting_equipment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->foreign('fleet_id')->references('fleet_id')->on('tbl_fleet')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->foreign('role_id')->references('pic_role_id')->on('tbl_setting_pic_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('vessel_id')->on('tbl_vessel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->foreign('role_id')->references('pic_role_id')->on('tbl_setting_pic_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_company', function(Blueprint $table) {
			$table->foreign('city_port_id')->references('city_port_id')->on('tbl_setting_city_port')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_city_port', function(Blueprint $table) {
			$table->foreign('country_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->foreign('fleet_id')->references('fleet_id')->on('tbl_fleet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->foreign('user_id_old')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->foreign('user_id_new')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_vessel_type', function(Blueprint $table) {
			$table->foreign('form_id')->references('form_id')->on('tbl_setting_form')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_form_particular', function(Blueprint $table) {
			$table->foreign('form_id')->references('form_id')->on('tbl_setting_form')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_form_particular', function(Blueprint $table) {
			$table->foreign('particular_id')->references('particular_id')->on('tbl_setting_particular')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_company_user', function(Blueprint $table) {
			$table->foreign('company_id')->references('company_id')->on('tbl_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_company_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_service_report', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('vessel_id')->on('tbl_vessel')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_service_report', function(Blueprint $table) {
			$table->foreign('vessel_equipment_type_id')->references('vessel_equipment_id')->on('tbl_vessel_equipment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_user_contact', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_user_contact', function(Blueprint $table) {
			$table->foreign('contact_id')->references('user_id')->on('tbl_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_setting_equipment', function(Blueprint $table) {
			$table->foreign('equipment_type_id')->references('equipment_type_id')->on('tbl_setting_equipment_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_equipment_attention_date', function(Blueprint $table) {
			$table->foreign('vessel_equipment_id')->references('vessel_equipment_id')->on('tbl_vessel_equipment')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_equipment_attention_date', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('vessel_id')->on('tbl_vessel')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_equipment_type', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('vessel_id')->on('tbl_vessel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbl_vessel_equipment_type', function(Blueprint $table) {
			$table->foreign('equipment_category_id')->references('equipment_category_id')->on('tbl_setting_equipment_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tbl_user', function(Blueprint $table) {
			$table->dropForeign('tbl_user_company_id_foreign');
		});
		Schema::table('tbl_setting_equipment_type', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_equipment_type_equipment_category_id_foreign');
		});
		Schema::table('tbl_setting_particular', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_particular_particular_category_id_foreign');
		});
		Schema::table('tbl_fleet', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_owner_id_foreign');
		});
		Schema::table('tbl_fleet', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_user_id_foreign');
		});
		Schema::table('tbl_vessel', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_fleet_id_foreign');
		});
		Schema::table('tbl_vessel', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_vessel_type_id_foreign');
		});
		Schema::table('tbl_vessel_particular', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_particular_vessel_id_foreign');
		});
		Schema::table('tbl_vessel_particular', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_particular_particular_id_foreign');
		});
		Schema::table('tbl_vessel_equipment', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_vessel_equipment_type_id_foreign');
		});
		Schema::table('tbl_vessel_equipment', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_equipment_id_foreign');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_pic_user_id_foreign');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_pic_fleet_id_foreign');
		});
		Schema::table('tbl_fleet_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_pic_role_id_foreign');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_pic_user_id_foreign');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_pic_vessel_id_foreign');
		});
		Schema::table('tbl_vessel_pic', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_pic_role_id_foreign');
		});
		Schema::table('tbl_company', function(Blueprint $table) {
			$table->dropForeign('tbl_company_city_port_id_foreign');
		});
		Schema::table('tbl_setting_city_port', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_city_port_country_id_foreign');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_ownership_transfer_fleet_id_foreign');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_ownership_transfer_user_id_old_foreign');
		});
		Schema::table('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->dropForeign('tbl_fleet_ownership_transfer_user_id_new_foreign');
		});
		Schema::table('tbl_setting_vessel_type', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_vessel_type_form_id_foreign');
		});
		Schema::table('tbl_setting_form_particular', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_form_particular_form_id_foreign');
		});
		Schema::table('tbl_setting_form_particular', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_form_particular_particular_id_foreign');
		});
		Schema::table('tbl_company_user', function(Blueprint $table) {
			$table->dropForeign('tbl_company_user_company_id_foreign');
		});
		Schema::table('tbl_company_user', function(Blueprint $table) {
			$table->dropForeign('tbl_company_user_user_id_foreign');
		});
		Schema::table('tbl_vessel_service_report', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_service_report_vessel_id_foreign');
		});
		Schema::table('tbl_vessel_service_report', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_service_report_vessel_equipment_type_id_foreign');
		});
		Schema::table('tbl_user_contact', function(Blueprint $table) {
			$table->dropForeign('tbl_user_contact_user_id_foreign');
		});
		Schema::table('tbl_user_contact', function(Blueprint $table) {
			$table->dropForeign('tbl_user_contact_contact_id_foreign');
		});
		Schema::table('tbl_setting_equipment', function(Blueprint $table) {
			$table->dropForeign('tbl_setting_equipment_equipment_type_id_foreign');
		});
		Schema::table('tbl_vessel_equipment_attention_date', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_attention_date_vessel_equipment_id_foreign');
		});
		Schema::table('tbl_vessel_equipment_attention_date', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_attention_date_vessel_id_foreign');
		});
		Schema::table('tbl_vessel_equipment_type', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_type_vessel_id_foreign');
		});
		Schema::table('tbl_vessel_equipment_type', function(Blueprint $table) {
			$table->dropForeign('tbl_vessel_equipment_type_equipment_category_id_foreign');
		});
	}
}