<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblVesselEquipmentTypeTable extends Migration {

	public function up()
	{
		Schema::create('tbl_vessel_equipment_type', function(Blueprint $table) {
			$table->increments('vessel_equipment_type_id');
			$table->integer('vessel_id')->unsigned();
			$table->integer('equipment_type_id')->unsigned();
			$table->integer('equipment_category_id')->unsigned();
			$table->string('vessel_equipment_type_name', 100);
			$table->enum('warning_type', array('danger', 'warning'))->nullable();
			$table->datetime('vessel_equipment_created');
			$table->datetime('vessel_equipment_updated');
		});
	}

	public function down()
	{
		Schema::drop('tbl_vessel_equipment_type');
	}
}