<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingVesselTypeTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_vessel_type', function(Blueprint $table) {
			$table->increments('vessel_type_id', true);
			$table->integer('vessel_type_priority');
			$table->string('vessel_type_name', 100);
			$table->enum('vessel_type_status', array(''));
			$table->integer('form_id')->unsigned();
			$table->datetime('vessel_type_created');
			$table->datetime('vessel_type_updated');
			$table->datetime('vessel_type_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_vessel_type');
	}
}