<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->text('details_en')->nullable();
			$table->text('details_ar')->nullable();
			$table->integer('total_views')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}