<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ad extends Model 
{

    protected $table = 'ad';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('seller_id', 'category_id', 'status', 'expire_at', 'guarantee', 'price', 'details');

    public function tags()
    {
        return $this->belongsToMany('Tag', 'add_tag', 'add_id', 'tag_id');
    }

    public function types()
    {
        return $this->belongsToMany('TagType', 'addtype', 'add_id', 'type_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function seller()
    {
        return $this->belongsTo('User', 'seller_id');
    }

}