<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('coupon_num');
			$table->enum('type', array('ratio', 'number'));
			$table->decimal('discount', 10, 8);
			$table->decimal('max_discount', 10, 8)->nullable();
			$table->datetime('expire_date')->nullable();
			$table->integer('max_use');
			$table->integer('use_times')->default('0');
			$table->enum('status', array('available'', ''expire'', ''usage_end'', ''closed'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}