<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('attachable');
			$table->string('file_path');
			$table->string('file_type')->nullable();
			$table->enum('status', array('1:pending', '2:accepted', '3:rejected'));
			$table->boolean('deleted')->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}