<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WinningBalance extends Eloquent {

	protected $table = 'winning_balance';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_user_id', 'to_user_id', 'amount');

	public function userWinAmount()
	{
		return $this->belongsTo('User', 'from_user_id');
	}

}