<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CashBalance extends Eloquent {

	protected $table = 'cash_balance';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_user_id', 'to_user_id', 'balance');

	public function userBalance()
	{
		return $this->hasMany('User', 'from_user_id');
	}

}