<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceLinesTable extends Migration {

	public function up()
	{
		Schema::create('invoice_lines', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('Invoice_id')->unsigned();
			$table->integer('Declaration_id')->unsigned();
			$table->string('BSN', 20);
			$table->string('EmployeeName', 255);
			$table->string('Kind', 50);
			$table->date('PeriodFrom');
			$table->date('PeriodTo');
			$table->float('Amount');
			$table->float('WE');
			$table->float('WA');
			$table->float('WAO');
			$table->float('WGA');
			$table->float('ZVW');
			$table->float('TotalAmount');
			$table->boolean('Validated');
			$table->integer('ValidatedByUser_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('invoice_lines');
	}
}