<?php

namespace App\Models;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;
	protected $fillable = array('user_id', 'category_id', 'name', 'description', 'period', 'price', 'price_min', 'price_max', 'type');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\ServiceCategory', 'category_id');
	}

}