<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutcomeTableTable extends Migration {

	public function up()
	{
		Schema::create('outcomeTable', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('category', array('driver', 'truck', 'maintenance', 'any', 'client'));
			$table->enum('status', array('active', 'deleted', 'done'));
			$table->integer('rideId');
			$table->integer('truckId');
			$table->integer('driverId');
			$table->string('name');
			$table->integer('Sum');
		});
	}

	public function down()
	{
		Schema::drop('outcomeTable');
	}
}