<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50);
			$table->string('phone', 50)->unique();
			$table->string('country_code', 25);
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->string('image');
			$table->string('email', 25);
			$table->boolean('is_active');
			$table->boolean('is_approved');
			$table->boolean('is_blocked');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}