<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHealthProfilesTable extends Migration {

	public function up()
	{
		Schema::create('Health_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->string('name', 255);
			$table->tinyInteger('gender');
			$table->string('relationship', 20);
			$table->date('birthday');
			$table->string('mobile', 20);
			$table->text('accesser');
			$table->text('owner');
			$table->string('blood_type', 10);
			$table->string('note', 255);
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Health_profiles');
	}
}