<?php

class Usuarios extends Eloquent {

	protected $table = 'usuarios';
	public $timestamps = true;

	public function comentarios()
	{
		return $this->hasMany('Comentarios', 'usuario_id');
	}

	public function listas()
	{
		return $this->hasMany('Listas', 'usuario_id');
	}

	public function reservas()
	{
		return $this->hasMany('Reservas', 'usuario_id');
	}

	public function estantes()
	{
		return $this->hasMany('Estantes', 'usuario_id');
	}

	public function libros()
	{
		return $this->belongsToMany('Libros', 'libro_usuario', 'usuario_id', 'libro_id')->withPivot('leido', 'quiero_leer');
	}

}