<?php

class Libros extends Eloquent {

	protected $table = 'libros';
	public $timestamps = true;

	public function comentarios()
	{
		return $this->hasMany('Comentarios', 'libro_id');
	}

	public function autores()
	{
		return $this->belongsToMany('Autores', 'libro_autor', 'libro_id', 'autor_id');
	}

	public function categorias()
	{
		return $this->belongsToMany('Categorias', 'libro_categoria', 'libro_id', 'categoria_id');
	}

	public function listas()
	{
		return $this->belongsToMany('Listas', 'libro_lista', 'libro_id', 'lista_id');
	}

	public function usuarios()
	{
		return $this->belongsToMany('Usuarios', 'libro_usuarios', 'libro_id', 'usuario_id');
	}

	public function editorial()
	{
		return $this->belongsTo('Editoriales', 'editorial_id');
	}

	public function reservas()
	{
		return $this->hasMany('Reservas', 'libro_id');
	}

}