<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParkingZonesTable extends Migration {

	public function up()
	{
		Schema::create('parking_zones', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 70)->nullable();
			$table->string('address', 70);
			$table->string('latitude', 20);
			$table->string('longitude', 20);
			$table->integer('perimeter');
			$table->timestamps();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('parking_zones');
	}
}