<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiteraturesTable extends Migration {

	public function up()
	{
		Schema::create('literatures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('slug')->unique();
			$table->integer('year_of_publication')->unsigned()->nullable();
			$table->string('isbn');
			$table->string('issue')->nullable();
			$table->text('reference')->nullable();
			$table->string('volume')->nullable();
			$table->string('pages')->nullable();
			$table->string('url')->nullable();
			$table->integer('publisher_id')->unsigned();
			$table->integer('source_type_id')->unsigned()->nullable();
			$table->integer('source_literature_id')->unsigned();
			$table->datetime('published_at')->nullable();
			$table->integer('published_by')->unique()->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('literatures');
	}
}