<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Literature extends Model 
{

    protected $table = 'literatures';
    public $timestamps = true;

    public function sourceType()
    {
        return $this->belongsTo('SourceType');
    }

    public function publishers()
    {
        return $this->belongsToMany('Publisher');
    }

    public function authors()
    {
        return $this->belongsToMany('Author');
    }

    public function publishedBy()
    {
        return $this->belongsTo('User');
    }

    public function sourceLiterature()
    {
        return $this->belongsTo('Literature');
    }

}