<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('support_code', 'name', 'organization', 'country_id', 'address', 'telephone', 'activity', 'know_us_from');

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

	public function subscribtions()
	{
		return $this->hasMany('App\Models\Subscription');
	}

	public function clientPayments()
	{
		return $this->hasMany('App\Models\ClientPayment');
	}

	public function ticketReplies()
	{
		return $this->hasMany('App\Models\TicketReplay');
	}

	public function tickets()
	{
		return $this->hasMany('App\Models\Ticket');
	}

	public function changeDevices()
	{
		return $this->hasMany('App\Models\ChangeDevice');
	}

}