<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type');
			$table->string('username')->index();
			$table->string('email')->unique();
			$table->date('birthdate')->nullable();
			$table->bigInteger('language_id')->unsigned()->nullable();
			$table->string('phone')->unique();
			$table->string('password');
			$table->tinyInteger('active')->unsigned()->default('1');
			$table->timestamp('last_login_at');
			$table->string('last_login_ip')->nullable();
			$table->string('confirmation_code')->nullable();
			$table->text('avatar')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('job_position');
			$table->text('cv')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}