<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('parent_id')->unsigned()->nullable()->index();
			$table->string('name');
			$table->string('slug')->unique();
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}