<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name', 'parent_id');

    public function category()
    {
        return $this->belongsTo('Models\Category', 'parent_id');
    }

    public function categories()
    {
        return $this->hasMany('Models\Category', 'parent_id');
    }

    public function auctions()
    {
        return $this->hasMany('Models\Auction', 'category_id');
    }

    public function users()
    {
        return $this->belongsToMany('\User', 'interests', 'category_id', 'user_id');
    }

}