<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Auction extends Model 
{

    protected $table = 'auction';
    public $timestamps = true;
    protected $fillable = array('title', 'start_date', 'end_date', 'description', 'start_price', 'last_price', 'count', 'user_id', 'city_id', 'type', 'winner_id', 'category_id', 'address', 'status', 'auction_status', 'id_firebase');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function city()
    {
        return $this->belongsTo('Models\City', 'city_id');
    }

    public function winner()
    {
        return $this->belongsTo('\User', 'winner_id');
    }

    public function category()
    {
        return $this->belongsTo('Models\Category', 'category_id');
    }

    public function images()
    {
        return $this->hasMany('Models\Image', 'auction_id');
    }

    public function sliders()
    {
        return $this->hasMany('Models\Slider', 'auction_id');
    }

    public function comments()
    {
        return $this->hasMany('Models\Comment', 'auction_id');
    }

    public function favourite_users()
    {
        return $this->belongsToMany('\User', 'favourites', 'auction_id', 'user_id');
    }

    public function reports()
    {
        return $this->hasMany('Models\Report', 'auction_id');
    }

}