<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('equipment', function(Blueprint $table) {
			$table->foreign('id_ov_foreign_key')->references('id_ov')->on('ov')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module', function(Blueprint $table) {
			$table->foreign('id_equipment_foreign_key')->references('id_equipment')->on('equipment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('license', function(Blueprint $table) {
			$table->foreign('id_ov_foreign_key')->references('id_ov')->on('ov')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('license', function(Blueprint $table) {
			$table->foreign('id_equipment_foreign_key')->references('id_equipment')->on('equipment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('equipment', function(Blueprint $table) {
			$table->dropForeign('equipment_id_ov_foreign_key_foreign');
		});
		Schema::table('module', function(Blueprint $table) {
			$table->dropForeign('module_id_equipment_foreign_key_foreign');
		});
		Schema::table('license', function(Blueprint $table) {
			$table->dropForeign('license_id_ov_foreign_key_foreign');
		});
		Schema::table('license', function(Blueprint $table) {
			$table->dropForeign('license_id_equipment_foreign_key_foreign');
		});
	}
}