<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Equipment extends Model 
{

    protected $table = 'equipment';
    public $timestamps = false;
    protected $fillable = array('baseMacAddress', 'baseSoftwareVersion', 'baseSerialNumber', 'lastKnownUpAt', 'sysUpTime', 'chassisAdminStatus', 'chassisOperationalStatus', 'name', 'model');

    public function modules()
    {
        return $this->hasMany('Module', 'id_equipment_foreign_key');
    }

    public function licenses()
    {
        return $this->hasMany('License', 'id_equipment_foreign_key');
    }

}