<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobHistory extends Model 
{

    protected $table = 'job_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'hired', 'company_name', 'story');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}