<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('addressable');
			$table->json('address_name');
			$table->json('address_line1');
			$table->json('address_line2');
			$table->string('building_number');
			$table->string('floor_number');
			$table->string('phone');
			$table->string('postal_code');
			$table->string('long');
			$table->string('lat');
			$table->json('land_mark');
			$table->integer('country_id');
			$table->boolean('is_default');
			$table->boolean('is_active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}