<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContactDetails extends Model 
{

    protected $table = 'contact-details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type', 'value', 'icon', 'title', 'order', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('Branch');
    }

}