<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contact extends Eloquent {

	protected $table = 'contacts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('home', 'office', 'mobile', 'fax', 'user_id');
	protected $visible = array('home', 'office', 'mobile', 'fax', 'user_id');

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

}