<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('barcode', 30);
			$table->string('sku', 32);
			$table->string('color', 30)->nullable();
			$table->string('size', 5)->nullable();
			$table->string('brand', 30)->nullable();
			$table->text('remark')->nullable();
			$table->bigInteger('status_id')->unsigned();
			$table->string('order_id', 20);
			$table->string('type', 100)->nullable();
			$table->bigInteger('machine_type_id')->unsigned();
			$table->bigInteger('wash_program_id')->unsigned();
			$table->bigInteger('drying_rotation_id')->unsigned();
			$table->string('wash_type', 80)->default('normal');
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}