<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagoTable extends Migration {

	public function up()
	{
		Schema::create('pago', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('op_suscripcionlog_id')->nullable();
			$table->integer('user_id')->nullable()->index();
			$table->integer('suscripcion_id')->nullable()->index();
			$table->double('monto', 8,2)->nullable();
			$table->string('estado', 45)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pago');
	}
}