<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('email', 200)->unique();
			$table->string('telefono', 20)->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password', 200);
			$table->tinyInteger('active')->default('0');
			$table->string('activation_token', 200);
			$table->string('remember_token', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}