<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class District extends Model 
{

    protected $table = 'districts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function locations()
    {
        return $this->hasMany('Location');
    }

    public function wards()
    {
        return $this->hasMany('Wars');
    }

}