<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function farmers()
	{
		return $this->hasMany('App\Models\FarmerGroup');
	}

	public function location()
	{
		return $this->hasOne('Location');
	}

	public function leaders()
	{
		return $this->hasMany('\GroupLeader');
	}

}