<?php

namespace App\Models\Commandes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Commande extends Eloquent {

	protected $table = 'commandes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function trajet()
	{
		return $this->belongsTo('App\Models\Trajet\Trajet');
	}

	public function payement()
	{
		return $this->belongsTo('App\Models\Payement\Payement');
	}

	public function tarif()
	{
		return $this->belongsTo('App\Models\Tarif\Tarif');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client\Client');
	}

}