<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('email', 'first_name', 'last_name', 'active');
	protected $visible = array('email', 'first_name', 'last_name', 'active');
	protected $hidden = array('password');

	public function counties()
	{
		return $this->belongsToMany('App\Models\County', 'user_id');
	}

	public function notification()
	{
		return $this->hasMany('App\Models\Notification', 'user_id');
	}

}