<?php

namespace App\Models;

class InquiryMilestone extends Eloquent {

	protected $table = 'inquiry_milestone';
	public $timestamps = true;
	protected $fillable = array('inquiry_id', 'milestone_id', 'contact_type_id');
	protected $visible = array('inquiry_id', 'milestone_id', 'contact_type_id');

	public function contact_type()
	{
		return $this->belongsTo('App\Models\ContactType', 'contact_type_id');
	}

	public function inquiry()
	{
		return $this->belongsTo('App\Models\Inquiry');
	}

	public function milestone()
	{
		return $this->belongsTo('App\Milestones\Milestone', 'milestone_id');
	}

}