<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Inquiry extends Eloquent {

	protected $table = 'inquiries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function notification_recipients()
	{
		return $this->hasMany('App\Models\Notification_Recipients', 'inquiry_id');
	}

	public function inquiry_milestones()
	{
		return $this->hasMany('App\Models\InquiryMilestone', 'inquiry_id');
	}

	public function inquiry_answers()
	{
		return $this->hasMany('App\Models\InquiryAnswer', 'inquiry_id');
	}

}