<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Zone extends Eloquent {

	protected $table = 'zones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function arays()
	{
		return $this->hasMany('Aray');
	}

	public function shelters()
	{
		return $this->hasMany('Shelter');
	}

	public function site()
	{
		return $this->belongsTo('Site');
	}

}