<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Data extends Eloquent {

	protected $table = 'datas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sites()
	{
		return $this->hasMany('Site');
	}

	public function pieceJointes()
	{
		return $this->hasMany('PieceJointe');
	}

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function Gender()
	{
		return $this->belongsTo('Gender');
	}

	public function account()
	{
		return $this->belongsTo('Account');
	}

	public function accountType()
	{
		return $this->belongsTo('AccountType');
	}

}