<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TradeGroup extends Eloquent {

	protected $table = 'trade_groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'surname', 'slug', 'icon', 'description', 'cover_file');

	public function trades()
	{
		return $this->hasMany('App\Models\Trade', 'trade_group_id');
	}

}