<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Favorite extends Eloquent {

	protected $table = 'favorites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('author_id', 'profile_id');

	public function profile()
	{
		return $this->belongsTo('App\Models\Profile', 'profile_id');
	}

}