<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTradesTable extends Migration {

	public function up()
	{
		Schema::create('trades', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->string('slug')->unique();
			$table->bigInteger('icon')->nullable();
			$table->longText('description');
			$table->bigInteger('parent_id')->unsigned();
			$table->bigInteger('trade_group_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('trades');
	}
}